package com.retrytech.strangerapp.utils.ads;

import android.app.Activity;
import android.content.Context;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.retrytech.strangerapp.utils.SessionManager;

public class MyInterstitialAds {

    SessionManager sessionManager;
    private Context context;
    private InterstitialAd mInterstitialAd;

    public MyInterstitialAds(Context context) {
        this.context = context;
        initAds();
    }


    private void initAds() {
        sessionManager = new SessionManager(context);
        AdRequest adRequest = new AdRequest.Builder().build();
        InterstitialAd.load(context, sessionManager.getAppSettings().getAdmobs().getIntersialId(), adRequest, new InterstitialAdLoadCallback() {
            @Override
            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
            }

            @Override
            public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                super.onAdLoaded(interstitialAd);
                mInterstitialAd = interstitialAd;
            }
        });


    }


    public void showAds() {
        if (mInterstitialAd != null) {
            mInterstitialAd.show((Activity) context);
        }
    }
}

