package com.retrytech.strangerapp.utils.ads;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.retrytech.strangerapp.R;


public class DefaultNativeView extends LinearLayout {

    public DefaultNativeView(@NonNull Context context) {
        super(context);
        initNative();
    }

    public DefaultNativeView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initNative();
    }

    public DefaultNativeView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initNative();
    }

    public DefaultNativeView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        initNative();
    }

    public Activity activity;

    private void initNative() {
        if (activity != null) {
            new CustomNativeAds(activity, this, R.layout.admob_native_new);
        }
    }
}
