package com.retrytech.strangerapp.activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.WindowInsets;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.databinding.DataBindingUtil;

import com.retrytech.strangerapp.R;
import com.retrytech.strangerapp.databinding.ActivitySplashBinding;
import com.retrytech.strangerapp.modal.User;
import com.retrytech.strangerapp.modal.settings.AppSettings;
import com.retrytech.strangerapp.retrofit.Const;
import com.retrytech.strangerapp.retrofit.RetrofitClient;
import com.retrytech.strangerapp.utils.SessionManager;

import java.util.HashMap;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SplashActivity extends AppCompatActivity {

    ActivitySplashBinding binding;
    SessionManager sessionManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        View decorView = getWindow().getDecorView();
        decorView.setOnApplyWindowInsetsListener((v, insets) -> {
            WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
            return defaultInsets.replaceSystemWindowInsets(
                    defaultInsets.getSystemWindowInsetLeft(),
                    0,
                    defaultInsets.getSystemWindowInsetRight(),
                    defaultInsets.getSystemWindowInsetBottom());
        });
        ViewCompat.requestApplyInsets(decorView);
        getWindow().setStatusBarColor(ContextCompat.getColor(this, android.R.color.transparent));

        binding = DataBindingUtil.setContentView(this, R.layout.activity_splash);
        sessionManager = new SessionManager(this);

        Call<AppSettings> call = RetrofitClient.getService().fetchSettingsData(Const.API_KEY, 1);
        call.enqueue(new Callback<AppSettings>() {
            @Override
            public void onResponse(Call<AppSettings> call, Response<AppSettings> response) {
                if (response.body() != null) {
                    AppSettings settings = response.body();
                    Log.d("TAG", "onResponse: " + settings.getAdmobs().getAdmobAppId());
                    sessionManager.saveAppSettings(settings);
                    Log.d("TAG", "onResponse: " + sessionManager.getAppSettings().getAdmobs().getAdmobAppId());
                    binding.tvGetStarted.setVisibility(View.VISIBLE);
                    binding.loader.setVisibility(View.GONE);
                }
            }

            @Override
            public void onFailure(Call<AppSettings> call, Throwable t) {

            }
        });

        binding.tvGetStarted.setOnClickListener(view -> {
            if (sessionManager.getUser() != null) {
                fetchUserDetails();
                if (sessionManager.getUser().getData().getGender() == -1) {
                    startActivity(new Intent(SplashActivity.this, GenderSelectActivity.class));
                } else {
                    startActivity(new Intent(SplashActivity.this, MainActivity.class));
                }
            } else {
                startActivity(new Intent(SplashActivity.this, LoginActivity.class));
            }
            finishAffinity();
        });


    }

    private void fetchUserDetails() {
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("identity", sessionManager.getUser().getData().getIdentity());
        hashMap.put("fullname", sessionManager.getUser().getData().getFullname());

        Call<User> call = RetrofitClient.getService().registerUser(Const.API_KEY, hashMap);
        call.enqueue(new Callback<User>() {
            @Override
            public void onResponse(Call<User> call, Response<User> response) {
                if (response.body() != null) {
                    User user = response.body();
                    sessionManager.saveUser(user);
                }
            }

            @Override
            public void onFailure(Call<User> call, Throwable t) {

            }
        });
    }
}