package com.retrytech.strangerapp.activity;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.WindowInsets;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.databinding.DataBindingUtil;

import com.bumptech.glide.Glide;
import com.retrytech.strangerapp.R;
import com.retrytech.strangerapp.databinding.ActivitySearchingBinding;
import com.retrytech.strangerapp.modal.User;
import com.retrytech.strangerapp.retrofit.Const;
import com.retrytech.strangerapp.retrofit.RetrofitClient;
import com.retrytech.strangerapp.utils.SessionManager;
import com.retrytech.strangerapp.utils.sample.RtcTokenBuilderSample;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SearchingActivity extends AppCompatActivity {

    ActivitySearchingBinding binding;
    SessionManager sessionManager;
    String token;
    int userId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        View decorView = getWindow().getDecorView();
        decorView.setOnApplyWindowInsetsListener((v, insets) -> {
            WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
            return defaultInsets.replaceSystemWindowInsets(
                    defaultInsets.getSystemWindowInsetLeft(),
                    0,
                    defaultInsets.getSystemWindowInsetRight(),
                    defaultInsets.getSystemWindowInsetBottom());
        });
        ViewCompat.requestApplyInsets(decorView);
        getWindow().setStatusBarColor(ContextCompat.getColor(this, android.R.color.transparent));


        binding = DataBindingUtil.setContentView(this, R.layout.activity_searching);
        sessionManager = new SessionManager(this);
        userId = sessionManager.getUser().getData().getId();


        token = new RtcTokenBuilderSample().generateToken(sessionManager.getUser().getData().getIdentity(), 0);
        Log.d("TAG", "onCreate: " + token);

        Glide.with(this)
                .load(Const.ITEM_URL + sessionManager.getUser().getData().getImage())
                .circleCrop()
                .into(binding.imgUser);


//        callForSearchUser();

    }

    boolean isConnected = false;

    private void callForSearchUser() {
//
//        Call<User> call = RetrofitClient.getService().searchForCall(Const.API_KEY, userId, token);
//        call.enqueue(new Callback<User>() {
//            @Override
//            public void onResponse(Call<User> call, Response<User> response) {
//                if (response.body() != null) {
//                    User user = response.body();
//
//                    if (user.getData() != null) {
//                        startActivity(new Intent(SearchingActivity.this, CallActivity.class)
//                                .putExtra("user", new Gson().toJson(user.getData()))
//                                .putExtra("channelName", user.getData().getIdentity())
//                                .putExtra("token", user.getData().getToken())
//                        );
//                        isConnected = true;
//                        onBackPressed();
//                    }
//
//                }
//            }
//
//            @Override
//            public void onFailure(Call<User> call, Throwable t) {
////
//            }
//        });
    }

    @Override
    protected void onDestroy() {
        if (!isConnected) {
            resetUserCallStatus();
        }
        super.onDestroy();
    }


    private void resetUserCallStatus() {
        Call<User> call = RetrofitClient.getService().resetUserCallStatus(Const.API_KEY, sessionManager.getUser().getData().getId());
        call.enqueue(new Callback<User>() {
            @Override
            public void onResponse(Call<User> call, Response<User> response) {
                if (response.body() != null) {
                    User user = response.body();

                }
            }

            @Override
            public void onFailure(Call<User> call, Throwable t) {
//
            }
        });
    }
}