package com.retrytech.strangerapp.activity;

import android.app.Dialog;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowInsets;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.databinding.DataBindingUtil;

import com.retrytech.strangerapp.R;
import com.retrytech.strangerapp.databinding.ActivityGenderSelectBinding;
import com.retrytech.strangerapp.modal.User;
import com.retrytech.strangerapp.modal.settings.AppSettings;
import com.retrytech.strangerapp.retrofit.Const;
import com.retrytech.strangerapp.retrofit.RetrofitClient;
import com.retrytech.strangerapp.utils.SessionManager;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GenderSelectActivity extends AppCompatActivity {
    ActivityGenderSelectBinding binding;
    SessionManager sessionManager;
    int gender = -1;
    private Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View decorView = getWindow().getDecorView();
        decorView.setOnApplyWindowInsetsListener((v, insets) -> {
            WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
            return defaultInsets.replaceSystemWindowInsets(
                    defaultInsets.getSystemWindowInsetLeft(),
                    0,
                    defaultInsets.getSystemWindowInsetRight(),
                    defaultInsets.getSystemWindowInsetBottom());
        });
        ViewCompat.requestApplyInsets(decorView);
        getWindow().setStatusBarColor(ContextCompat.getColor(this, android.R.color.transparent));

        binding = DataBindingUtil.setContentView(this, R.layout.activity_gender_select);
        sessionManager = new SessionManager(this);

        dialog = new Dialog(this);
        View dialogueView = LayoutInflater.from(this).inflate(R.layout.item_loader, null, false);
        dialog.setContentView(dialogueView);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(ContextCompat.getColor(this, android.R.color.transparent)));

        binding.tvPrivacy.setOnClickListener(view -> {
            startActivity(new Intent(Intent.ACTION_VIEW,
                    Uri.parse(sessionManager.getAppSettings().getMiscs().getTerms())));
        });

        binding.tvTerms.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(sessionManager.getAppSettings().getMiscs().getTerms()));
            startActivity(browserIntent);
        });

        binding.imgMale.setOnClickListener(view -> {
            gender = 1;
            binding.imgMale.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            binding.imgMale.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.brown)));
            binding.imgFemale.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white_18)));
            binding.imgFemale.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
        });
        binding.imgFemale.setOnClickListener(view -> {
            gender = 0;
            binding.imgMale.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white_18)));
            binding.imgMale.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            binding.imgFemale.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.white)));
            binding.imgFemale.setImageTintList(ColorStateList.valueOf(ContextCompat.getColor(this, R.color.brown)));
        });

        binding.btnContinue.setOnClickListener(view -> {
            if (gender == -1) {
                Toast.makeText(this, getResources().getString(R.string.please_select_your_gender), Toast.LENGTH_SHORT).show();
            } else {
                updateGender();
            }
        });

    }

    private void updateGender() {
        dialog.show();
        Call<AppSettings> call = RetrofitClient.getService().updateGender(Const.API_KEY, gender, sessionManager.getUser().getData().getId());
        call.enqueue(new Callback<AppSettings>() {
            @Override
            public void onResponse(Call<AppSettings> call, Response<AppSettings> response) {
                if (response.body() != null) {
                    AppSettings settings = response.body();
                    if (settings.isStatus()) {

                        User user = sessionManager.getUser();
                        user.getData().setGender(gender);
                        sessionManager.saveUser(user);
                        dialog.dismiss();

                        startActivity(new Intent(GenderSelectActivity.this, MainActivity.class));
                        finishAffinity();
                    }
                }
            }

            @Override
            public void onFailure(Call<AppSettings> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(GenderSelectActivity.this, getResources().getString(R.string.something_went_wrong), Toast.LENGTH_SHORT).show();
            }
        });
    }
}